/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__request.c,v 1.11 2006/11/07 01:49:30 loic Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__request.h"
#include "mx__ack.h"

/***********
 * Timeout
 */

MX_FUNC(mx_return_t)
mx_set_request_timeout(mx_endpoint_t ep, mx_request_t request, uint32_t milliseconds)
{
/*  MX__MUTEX_LOCK(&ep->lock); */
/* dividing by 1024 instead of 1000 is accurate enough, and avoid costly div */
  if (request)
    request->basic.timeout = ((milliseconds * mx_jiffies_hz(ep)) >> 10) + 1;
  else
    ep->timeout = ((milliseconds * mx_jiffies_hz(ep)) >> 10) + 1;
/*  MX__MUTEX_UNLOCK(&ep->lock); */
  return MX_SUCCESS;
}

/***********
 * Request allocation
 */

void mx__rl__alloc(struct mx__request_lookaside *rl)
{
  char * buffer;
  int i;

  /* one request queue head to enqueue the buffer, and REQ_CHUNK full request */
  buffer = mx_malloc (sizeof(struct mx__request_queue_head) + REQ_CHUNK * sizeof(union mx_request));
  if (buffer != NULL) {
    struct mx__request_queue_head * head = (struct mx__request_queue_head *) buffer;

    /* link the requests together */
    union mx_request * reqs = (union mx_request *) (buffer + sizeof(struct mx__request_queue_head));
    for (i = 0; i < REQ_CHUNK-1; ++i) {
      MX_VALGRIND_MEMORY_MAKE_NOACCESS(&reqs[i], sizeof(reqs[i]));
      MX_VALGRIND_MEMORY_MAKE_WRITABLE(&reqs[i].basic.queue_elt.next,
                                       sizeof(reqs[i].basic.queue_elt.next));
      reqs[i].basic.queue_elt.next = &reqs[i+1].basic.queue_elt;
      if (MX_DEBUG) {
	MX_VALGRIND_MEMORY_MAKE_WRITABLE(&reqs[i].basic.state,
					 sizeof(reqs[i].basic.state));
	reqs[i].basic.state = MX__REQUEST_STATE_FREED;
      }
    }

    /* the last one links to the first current free one */
    reqs[REQ_CHUNK-1].basic.queue_elt.next = rl->free_requests_queue.next;
    rl->free_requests_queue.next = &reqs[0].basic.queue_elt;
    if (MX_DEBUG)
      reqs[REQ_CHUNK-1].basic.state = MX__REQUEST_STATE_FREED;

    /* update counters */
    rl->count += REQ_CHUNK;
    rl->alloc_count += REQ_CHUNK;

    /* link the buffer with the others */
    head->next = rl->request_buffers_queue.next;
    rl->request_buffers_queue.next = head;
  }
}

int mx__rl_init(struct mx__request_lookaside *rl)
{
  rl->alloc_count = rl->count = 0;
  rl->free_requests_queue.next = NULL;
  rl->request_buffers_queue.next = NULL;

  mx__rl__alloc(rl);
  if (!rl->alloc_count)
    return -1;

  return 0;
}

void mx__rl_fini(struct mx__request_lookaside *rl)
{
  struct mx__request_queue_head * buffer;
  while ((buffer = rl->request_buffers_queue.next) != NULL) {
    rl->request_buffers_queue.next = buffer->next;
    mx_free(buffer);
  }
}
